IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Eventos_Cbtes_Sincronizar') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Eventos_Cbtes_Sincronizar
END
GO

CREATE PROCEDURE dbo.CPJ_Eventos_Cbtes_Sincronizar @pJsonRecibido VARCHAR(MAX)
AS
SET NOCOUNT ON

	/***************************************************************************************************

	Procedimiento:      CPJ_Eventos_Cbtes_Sincronizar
	Fecha de Creacion:  2024-06-27
	Creado por:         Adriana Laverde
	Descripcion:        Stored creado para validar sincronizacion de localidades vendidas online por alta demanda
	Llamado por:        /modules/services/eventos_listas_sincronizar_localidades.php (ERP WEB)
	Tablas afectadas:  	 
	Usado en:           Administrador de Eventos y Abonos (ERP WEB)
	Parametro(s):       FlagUsarTrans, ModoDebug, Id_Lista_Evento, Id_Cliente, Id_Cliente_Titular, Fecha, Lote, Id_Producto, Json
	Forma de uso:       EXEC CPJ_Eventos_Cbtes_Sincronizar '{"FlagUsarTrans":"0","ModoDebug":"0","Id_Lista_Evento":"0","Id_Cliente":"1"
															,"Id_Cliente_Titular":"1","Fecha":"20240101","Lote":"FRO00000","Id_Producto":"","Json":""}'
	Notas adicionales:  --TO DO: STORED DE CP A CPJ (errores de versiones de sql)

	****************************************************************************************************

	SUMARIO DE CAMBIOS
	FECHA(yyyy-mm-dd)    Autor              Comentarios
	------------------- ------------------- ------------------------------------------------------------

              
	***************************************************************************************************/

/*Variables recibidas por parametro a traves del JSON*/
DECLARE	@pFlagUsarTrans			TINYINT,
		@pModoDebug				TINYINT,
		@pId_Lista_Evento		INT,
		@pId_Cliente			INT,
		@pId_Cliente_Titular	INT,
		@pFecha					DATETIME,
		@pLote					VARCHAR(20),
		@pId_Producto			VARCHAR(14),
		@pJson					VARCHAR(MAX)

SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'ModoDebug')), 0)
SET @pId_Lista_Evento			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Lista_Evento')),0)
SET @pId_Cliente				= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Cliente')),0)
SET @pId_Cliente_Titular		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Cliente_Titular')),0)
SET @pFecha						= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha')),'')
SET @pLote						= ISNULL(CONVERT(VARCHAR(20), dbo.CF_JSON_VALUE(@pJsonRecibido,'Lote')),'')
SET @pId_Producto				= ISNULL(CONVERT(VARCHAR(14), dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Producto')),'')
SET @pJson						= ISNULL(CONVERT(VARCHAR(MAX), dbo.CF_JSON_VALUE(@pJsonRecibido,'Json')),'')
/*FIN Variables recibidas por parametro a traves del JSON*/

/*Variable de Retorno del Stored*/
DECLARE @rtaErrorStored						INT
DECLARE @rtaMsjStored						VARCHAR(4000)
DECLARE @JSON_Parametros_Stored_Invocado	VARCHAR(8000)
DECLARE @rta_JSON_Stored_Invocado			VARCHAR(8000)
DECLARE @Result_Stored_Invocado				INT
DECLARE @Result_Tabla_Stored_Invocado		TABLE (ErrorNumber	INT,
											ErrorSeverity		INT,
											ErrorState			INT,
											ErrorProcedure  	VARCHAR(1000),
											ErrorLine			INT,
											ErrorMessage		VARCHAR(4000))
DECLARE @json								VARCHAR(8000)
/*FIN Variable de Retorono del Stored*/

/*Declaracion Variables Locales*/	
DECLARE @Contrato							INT
DECLARE @Id_Trans							INT
DECLARE @Id_Trans_Rec						INT
DECLARE @Id_Trans_Origen					INT
DECLARE @Respuesta_Json						VARCHAR(4000)
DECLARE @Id_Cliente							INT
DECLARE @Fecha_QA							DATETIME
DECLARE @Importe							DECIMAL(12,2)
DECLARE @Id_Producto						VARCHAR(14)
DECLARE @Lote								VARCHAR(20)
DECLARE @Id_Tipo_Cbte						CHAR(4)
DECLARE @Id_Tipo_Cbte_Rec					CHAR(4)
DECLARE @Fecha								DATETIME
DECLARE @Fecha_Venc							DATETIME
DECLARE @Fecha_Actual						DATETIME
DECLARE @Sincronizado						SMALLINT = 0
DECLARE @Existe								SMALLINT
DECLARE @Json_Prod							VARCHAR(8000)
DECLARE @UltError							INT
DECLARE @Id_Periodo_Caja					INT
DECLARE @Respuesta 							Table (ErrorNumber		INT,
											ErrorSeverity	INT,
											ErrorState		INT,
											ErrorProcedure  VARCHAR(1000),
											ErrorLine		INT,
											ErrorMessage	VARCHAR(1000)
											)
/*Fin de Declaraciones Variables Locales */

DECLARE @Usar_Trans			TINYINT
SET @Usar_Trans = 0

BEGIN TRY
	IF (@pFlagUsarTrans <> 0)
	BEGIN
		BEGIN TRAN
	END

	IF (@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Eventos_Cbtes_Sincronizar'
		PRINT 'Parametros: '+ @pJsonRecibido  
		PRINT ' ---------------------- '
	END

	IF (@pId_Cliente = 0)
	BEGIN
		SELECT  5001 AS ErrorNumber
			,1 AS ErrorSeverity
			,1 AS ErrorState
			,1 AS ErrorProcedure
			,1 AS ErrorLine
			,'Id_Cliente en cero' AS ErrorMessage
		RETURN 9999
	END

	SET @Id_Tipo_Cbte		= ISNULL((SELECT DBO.CF_xParam('Tipo_Cbte_VW_Factura')), 'ND')
	SET @Id_Tipo_Cbte_Rec	= ISNULL((SELECT DBO.CF_xParam('Tipo_Cbte_VW_Recibo')), 'REC')
	SET @Id_Periodo_Caja	= ISNULL((SELECT DBO.CF_xParam('Per_Caja_Cob_Web')), 0)
	SET @Existe				= ISNULL((SELECT TOP 1 1 FROM CBTES WHERE LOTE = @pLote AND Id_Estado_Cbte = 2 AND Id_Tipo_Cbte = @Id_Tipo_Cbte),0)

	SELECT  @Fecha		= Fecha_Evento,
			@Fecha_QA	= Evento_Desde,
			@Fecha_Venc = Evento_Hasta
	FROM Prod_Listas_Precios 
	WHERE Id_Lista_Precio = @pId_Lista_Evento

	SET @pJson = REPLACE(@pJson,'|','"')

    SELECT @Importe = dbo.CF_JSON_VALUE(columna,'total')
	FROM dbo.CF_Split(@pJson,'},')

	IF (@pModoDebug = 1)
	BEGIN
		PRINT 'Id_Producto: '+ CONVERT(VARCHAR(14),@pId_Producto)
		PRINT 'Id_Tipo_Cbte: '+ CONVERT(VARCHAR(14),@Id_Tipo_Cbte)
		PRINT 'Lote: '+ CONVERT(VARCHAR(20),@pLote)
		PRINT ' ---------------------- '
	END 
		

	IF (@Existe = 0)
	BEGIN

		IF (@Id_Tipo_Cbte <> '' AND @pId_Lista_Evento > 0)
		BEGIN

			SET @json =	'{'
			SET @json =	@json + '"FlagUsarTrans":"1"'
			SET @json =	@json +	',"ModoDebug":"0"'
			SET @json =	@json +	',"Id_Usuario":"-1"'
			SET @json =	@json +	',"Fecha":"' + CONVERT(VARCHAR(10), @pFecha, 112) +'"'
			SET @json =	@json +	',"FechaVence":"' + CONVERT(VARCHAR(10), @pFecha, 112) +'"'
			SET @json =	@json +	',"Id_Cliente":"' + CONVERT(VARCHAR(10), @pId_Cliente_Titular) +'"'
			SET @json =	@json +	',"Id_Lista_Precio":"' + CONVERT(VARCHAR(10), @pId_Lista_Evento) +'"'
			SET @json =	@json +	',"Id_Tipo_Cbte":"' + CONVERT(VARCHAR(4), @Id_Tipo_Cbte) +'"'
			SET @json =	@json +	',"Lote":"' + CONVERT(VARCHAR(20), @pLote) +'"'
			SET @json =	@json +	',"Id_Cond_Pago":"10"'
			SET @json =	@json +	',"Id_Moneda":"PES"'
			SET @json =	@json +	',"Cotizacion":"1"'
			SET @json =	@json +	'}'

			SET @Id_Trans = 0
			DELETE @Result_Tabla_Stored_Invocado
	
			INSERT INTO @Result_Tabla_Stored_Invocado  
			EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Fac_Generar @json

			IF ISNULL(@Result_Stored_Invocado, 0) <> 0 
			BEGIN
				RAISERROR ('Error when calling CPJ_Cbtes_Fac_Generar', 16,  1 ) 
			END
			ELSE
			BEGIN
				SELECT TOP 1 @rta_JSON_Stored_Invocado = ErrorMessage FROM @Result_Tabla_Stored_Invocado
				SET @Id_Trans = ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@rta_JSON_Stored_Invocado,'Id_Trans')), 0)
			END

			IF(@Id_Trans > 0)
			BEGIN
				SET @json =	'{'
				SET @json =	@json + '"FlagUsarTrans":"1"'
				SET @json =	@json +	',"ModoDebug":"0"'
				SET @json =	@json +	',"Id_Trans":"' + CONVERT(VARCHAR(10), @Id_Trans) +'"'
				SET @json =	@json +	',"Id_Cliente":"' + CONVERT(VARCHAR(10), @pId_Cliente) +'"'
				SET @json =	@json +	',"Id_Producto":"' + CONVERT(VARCHAR(10), @pId_Producto) +'"'
				SET @json =	@json +	',"Cantidad":"' + CONVERT(VARCHAR(10), 1) +'"'
				SET @json =	@json +	',"Precio_Grav":"' + CONVERT(VARCHAR(10), @Importe) +'"'
				SET @json =	@json +	',"Fecha_QA":"' + CONVERT(VARCHAR(10), @Fecha_QA, 112) +'"'
				SET @json =	@json +	',"Fecha_Venc":"' + CONVERT(VARCHAR(10), @Fecha_Venc, 112) +'"'
				SET @json =	@json +	'}'

				DELETE @Result_Tabla_Stored_Invocado
	
				INSERT INTO @Result_Tabla_Stored_Invocado 
				EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Fac_Generar_Item @json

				IF ISNULL(@Result_Stored_Invocado, 0) <> 0 
				BEGIN
					RAISERROR ('Error when calling CPJ_Cbtes_Fac_Generar_Item', 16,  1 ) 
				END
			END

			IF(@Id_Trans > 0)
			BEGIN
				SET @json =	'{'
				SET @json =	@json + '"FlagUsarTrans":"1"'
				SET @json =	@json +	',"ModoDebug":"0"'
				SET @json =	@json +	',"Id_Trans":"' + CONVERT(VARCHAR(10), @Id_Trans) +'"'
				SET @json =	@json +	',"Omitir_Resultado_OK":"' + CONVERT(VARCHAR(10), 1) +'"'
				SET @json =	@json +	'}'

				EXEC dbo.CPJ_Cbtes_Fac_Fin @json

			END

			IF(@Id_Trans > 0)
			BEGIN

				/*SET @json =	'{'
				SET @json =	@json + '"FlagUsarTrans":"0"'
				SET @json =	@json +	',"ModoDebug":"0"'
				SET @json =	@json +	',"Id_Usuario":"-1"'
				SET @json =	@json +	',"Fecha":"' + CONVERT(VARCHAR(10), @pFecha, 112) +'"'
				SET @json =	@json +	',"Importe":"' + CONVERT(VARCHAR(10), @Importe) +'"'
				SET @json =	@json +	',"Id_Cliente":"' + CONVERT(VARCHAR(10), @pId_Cliente) +'"'
				SET @json =	@json +	',"Id_Periodo_Caja":"' + CONVERT(VARCHAR(10), @Id_Periodo_Caja) +'"'
				SET @json =	@json +	',"Id_Tipo_Cbte":"' + CONVERT(VARCHAR(4), @Id_Tipo_Cbte_Rec) +'"'
				SET @json =	@json +	',"Lote":"' + CONVERT(VARCHAR(20), @pLote) +'"'
				SET @json =	@json +	',"Id_Moneda":"PES"'
				SET @json =	@json +	',"Cotizacion":"1"'
				SET @json =	@json +	'}'

				print @json

				SET @Id_Trans_Rec = 0
				DELETE @Result_Tabla_Stored_Invocado
	
				INSERT INTO @Result_Tabla_Stored_Invocado  
				EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Rec_Generar @json
				
				IF ISNULL(@Result_Stored_Invocado, 0) <> 0 
				BEGIN
					RAISERROR ('Error when calling CPJ_Cbtes_Rec_Generar', 16,  1 ) 
				END
				ELSE
				BEGIN
					SELECT TOP 1 @rta_JSON_Stored_Invocado = ErrorMessage FROM @Result_Tabla_Stored_Invocado
					SET @Id_Trans_Rec = ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@rta_JSON_Stored_Invocado,'Id_Trans')), 0)
				END*/

				SET @Id_Trans_Rec = 0

				DELETE @Respuesta
				INSERT INTO @Respuesta
				EXEC @UltError = CP_Cbtes_Rec_Generar -1, @pId_Cliente_Titular, '', @Id_Periodo_Caja, @pFecha, @Importe, @Id_Tipo_Cbte_Rec, 'PES', 1, @pLote, ''
				IF @UltError <> 0
					BEGIN
						IF @Usar_Trans = 1 AND @@TRANCOUNT > 0 ROLLBACK
						SELECT * FROM @Respuesta	
						RETURN 4567
					END
				ELSE	
					SELECT TOP 1 @Id_Trans_Rec = ErrorLine FROM @Respuesta

			END

			IF (@Id_Trans_Rec > 0)
			BEGIN

				SET @json =	'{'
				SET @json =	@json + '"FlagUsarTrans":"1"'
				SET @json =	@json +	',"ModoDebug":"0"'
				SET @json =	@json +	',"Id_Trans":"' + CONVERT(VARCHAR(10), @Id_Trans_Rec) +'"'
				SET @json =	@json +	',"Item":"' + CONVERT(VARCHAR(10), 1) +'"'
				SET @json =	@json +	',"Id_Producto":"' + CONVERT(VARCHAR(10), @pId_Producto) +'"'
				SET @json =	@json +	',"Cantidad":"' + CONVERT(VARCHAR(10), 1) +'"'
				SET @json =	@json +	',"Id_Trans_A_Cancelar":"' + CONVERT(VARCHAR(10), @Id_Trans) +'"'
				SET @json =	@json +	',"Importe_A_Cancelar":"' + CONVERT(VARCHAR(10), @Importe) +'"'
				SET @json =	@json +	',"Omitir_Resultado_OK":"' + CONVERT(VARCHAR(10), 1) +'"'
				SET @json =	@json +	'}'

				EXEC  dbo.CPJ_Cbtes_Rec_Generar_Item @json

			END
		
			IF(@Id_Trans_Rec > 0)
			BEGIN

				SET @json =	'{'
				SET @json =	@json + '"FlagUsarTrans":"1"'
				SET @json =	@json +	',"ModoDebug":"0"'
				SET @json =	@json +	',"Id_Trans":"' + CONVERT(VARCHAR(10), @Id_Trans_Rec) +'"'
				SET @json =	@json +	',"Fecha_Emision":"' + CONVERT(VARCHAR(10), @pFecha, 112) +'"'
				SET @json =	@json +	',"Fecha_Acreditacion":"' + CONVERT(VARCHAR(10), @pFecha, 112) +'"'
				SET @json =	@json +	',"Fecha_Vence":"' + CONVERT(VARCHAR(10), @pFecha, 112) +'"'
				SET @json =	@json +	',"Id_Tipo_Val":"DB"'
				SET @json =	@json +	',"Importe":"' + CONVERT(VARCHAR(10), @Importe) +'"'
				SET @json =	@json +	',"RtaMsjStored":"' + CONVERT(VARCHAR(10), 1) +'"'
				SET @json =	@json +	'}'

				EXEC dbo.CPJ_Cbtes_Rec_Generar_Pago @json
			END

			IF(@Id_Trans_Rec > 0)
			BEGIN
				/*SET @json =	'{'
				SET @json =	@json + '"FlagUsarTrans":"1"'
				SET @json =	@json +	',"ModoDebug":"0"'
				SET @json =	@json +	',"Omitir_Resultado_OK":"' + CONVERT(VARCHAR(10), 1) +'"'
				SET @json =	@json +	',"Id_Trans":"' + CONVERT(VARCHAR(10), @Id_Trans_Rec) +'"'
				--SET @json =	@json + ',"Flag_Renumerar":"1"'
				SET @json =	@json +	'}'
				--PRINT @json
		
				DELETE @Result_Tabla_Stored_Invocado
	
				INSERT INTO @Result_Tabla_Stored_Invocado 
				EXEC dbo.CPJ_Cbtes_Rec_Fin @json*/

				DELETE @Respuesta
				INSERT INTO @Respuesta
				EXEC @UltError = CP_Cbtes_Rec_Fin @Id_Trans_Rec

				IF ISNULL(@Result_Stored_Invocado, 0) <> 0 
				BEGIN
					RAISERROR ('Error when calling CPJ_Cbtes_Rec_Fin', 16,  1 ) 
				END
			END
		END

		IF(@Id_Trans > 0 AND @Id_Trans_Rec > 0)
		BEGIN
			SET @Sincronizado = 1
		END

	END
	ELSE
	BEGIN
		SET @Sincronizado = 1

		IF (@pModoDebug = 1)
		BEGIN
			PRINT 'Id_Cliente ya sincronizado'
			PRINT ' ---------------------- '
		END 
	END

	/*========================================================= RESULTADO =======================================================================================*/

		IF (@Sincronizado = 1)
		BEGIN
			SELECT @pId_Cliente AS 'Id_Cliente'
		END
		ELSE
		BEGIN
			SELECT 0 AS 'Error'
		END
	
	/*====================================================================================================================================================*/

	IF @pFlagUsarTrans <> 0 COMMIT
	
	/*====================================================================================================================================================*/

	IF (@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Eventos_Cbtes_Sincronizar'
	END
	
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0  ROLLBACK

	RETURN 9999
END CATCH

RETURN 0 